using Plots, JLD
############ load the dataset without quarantinie control
@load "/Users/urielyang/OneDrive - Emory University/Honors/workspace.jld"

############ load the dataset with quarantinie control
@load "/Users/urielyang/OneDrive - Emory University/Honors/predres_IT.jld"
@load "/Users/urielyang/OneDrive - Emory University/Honors/predres_WH.jld"
@load "/Users/urielyang/OneDrive - Emory University/Honors/predres_SK.jld"


############### P1 ###############
fntlg = Plots.font("sans-serif", pointsize=round(10.0))
fntlb = Plots.font("sans-serif", pointsize=round(7.0))
fntld = Plots.font("sans-serif", pointsize=round(10.0))
t_step = 0.0:1:79.0
default(titlefont=fntlg, guidefont=fntlb, legendfont=fntld)
p1 = scatter(t_step, y_wh[1:80], color = "blue", title = "Wuhan", markerstrokecolor = "blue",
    markersize = 2,legend = false, xlabel ="Days post 500 infected", ylabel = "Active confirmed cases")
scatter!(p1, t_step, x_wh[1:80], color = "red", markerstrokecolor = "red", markersize = 2)
plot!(p1, t_step, pred_WH[3, :], color = "blue")
plot!(p1, t_step, pred_WH[2, :], color = "red")
vline!([40], color = "black", linestyle = :dash)
p2 = scatter(t_step, y_sk[1:80], color = "blue", title = "South Korea", markerstrokecolor = "blue",
    markersize = 2, legend = false, xlabel ="Days post 500 infected", ylabel = "Active confirmed cases")
scatter!(p2, t_step, x_sk[1:80], color = "red", markerstrokecolor = "red", markersize = 2)
plot!(p2, t_step, pred_SK[3, 1:80], color = "blue")
plot!(p2, t_step, pred_SK[2, 1:80], color = "red")
vline!([40], color = "black", linestyle = :dash)
p3 = scatter(t_step, y_it[1:80], color = "blue", title = "Italy", markerstrokecolor = "blue",
    markersize = 2, legend = false, xlabel ="Days post 500 infected", ylabel = "Active confirmed cases")
scatter!(p3, t_step, x_it[1:80], color = "red", markerstrokecolor = "red",markersize = 2)
plot!(p3, t_step, pred_IT[3, :], color = "blue")
plot!(p3, t_step, pred_IT[2, :], color = "red")
vline!([40], color = "black", linestyle = :dash)
legend = plot([0], showaxis = false, legend=:left, grid = false, markerstrokecolor = "blue",
    label = "Data: recovered", marker=:circle, markersize=0.001, linetype=:scatter)
scatter!(legend, [0], color = "red", label = "Data: infectious", marker=:circle, markersize=0.001)
plot!(legend, [0], color = "blue", label = "Predicted recovered")
plot!(legend, [0], color = "red", label = "Predicted infectious")
plot!(legend, [0], color = "black",label = "Split for training and testing", linestyle = :dash)
p_final = plot(p1, p2, p3, legend, layout = @layout([a b; c d]), size=(800,500))
png(p_final, "/Users/urielyang/OneDrive - Emory University/Honors/Graphs/SEIR.png")

############### P2 ###############
fntlg = Plots.font("sans-serif", pointsize=round(10.0))
fntlb = Plots.font("sans-serif", pointsize=round(7.0))
fntld = Plots.font("sans-serif", pointsize=round(10.0))
t_step = 0.0:1:79.0
default(titlefont=fntlg, guidefont=fntlb, legendfont=fntld)
p1 = scatter(t_step, y_wh[1:80], color = "blue", title = "Wuhan", markerstrokecolor = "blue", label = "Data: recovered",
    markersize = 2,legend = false, xlabel ="Days post 500 infected", ylabel = "Active confirmed cases")
scatter!(p1, t_step, x_wh[1:80], color = "red", markerstrokecolor = "red", markersize = 2, label = "Data: infectious")
plot!(p1, t_step, pred_WH[3, :], color = "blue", label = "Predicted recovered")
plot!(p1, t_step, pred_WH[2, :], color = "red", label = "Predicted infectious")
vline!([40], color = "black", linestyle = :dash, legend = true)
plot!(p1, legend = :topleft, foreground_color_legend = nothing, legendfontsize = 6, background_color_legend = nothing)

p2 = scatter(t_step, y_sk[1:80], color = "blue", title = "South Korea", markerstrokecolor = "blue",
    markersize = 2, legend = false, xlabel ="Days post 500 infected", ylabel = "Active confirmed cases")
scatter!(p2, t_step, x_sk[1:80], color = "red", markerstrokecolor = "red", markersize = 2)
plot!(p2, t_step, pred_SK[3, 1:80], color = "blue")
plot!(p2, t_step, pred_SK[2, 1:80], color = "red")
vline!([40], color = "black", linestyle = :dash)
p3 = scatter(t_step, y_it[1:80], color = "blue", title = "Italy", markerstrokecolor = "blue",
    markersize = 2, legend = false, xlabel ="Days post 500 infected", ylabel = "Active confirmed cases")
scatter!(p3, t_step, x_it[1:80], color = "red", markerstrokecolor = "red",markersize = 2)
plot!(p3, t_step, pred_IT[3, :], color = "blue")
plot!(p3, t_step, pred_IT[2, :], color = "red")
vline!([40], color = "black", linestyle = :dash)

p4 = plot(t_step, q_IT[1:80], color = "green", title = "Estimated Quarantine Strength", label = "Italy",
    markersize = 2, xlabel ="Days post 500 infected", ylabel = "Q(t)", ylims = [0, 1])
plot!(p4, t_step, q_SK[1:80], color = "orange", label = "South Korea")
plot!(p4, t_step, q_WH[1:80], color = "black", label = "Wuhan")
vline!([40], color = "black", linestyle = :dash, label = nothing)
plot!(p4, legend = :bottomright, foreground_color_legend = nothing, background_color_legend = nothing,
    legendfontsize = 8)
p_final = plot(p1, p2, p3, p4, layout = @layout([a b; c d]))

############### P3 ###############
p1 = plot(loss_WH, color = "black", label = "Wuhan", markersize = 2,
    legend = false, xlabel ="Iterations", ylabel = "Training Loss", yaxis=:log)
plot!(p1, loss_SK, color = "orange", label = "South Korea")
plot!(p1, loss_IT, color = "green", label = "Italy", legend = :topright)
